import { NgFor, NgIf } from '@angular/common';
import { Component, OnInit } from '@angular/core';
import { FormsModule } from '@angular/forms';
import { MatButton } from '@angular/material/button';
import { MatCard, MatCardContent, MatCardHeader, MatCardSubtitle, MatCardTitle } from '@angular/material/card';
import { MatFormField, MatLabel } from '@angular/material/form-field';
import { MatInput } from '@angular/material/input';
import { MatToolbar } from '@angular/material/toolbar';
import { Router } from '@angular/router';
import { from } from 'rxjs';
import { catchError } from 'rxjs/operators';

import { AuthService } from '../auth/auth.service';
import { NoticeService } from '../notice/notice.service';
import { RemoteService } from '../service/remote.service';
import { BusyIndicator } from '../shared/busy/busy-indicator.service';

import * as metainfo from '../meta.json';
import { BusyIndicatorDirective } from '../shared/busy/busy-indicator.directive';

@Component({
    selector: 'app-logon',
    imports: [MatToolbar, NgIf, MatCard, MatCardContent, FormsModule, MatFormField, MatLabel, MatInput, MatButton, BusyIndicatorDirective, MatCardHeader, MatCardTitle, MatCardSubtitle, NgFor],
    templateUrl: './logon.component.html',
    styleUrls: ['./logon.component.css']
})
export class LogonComponent implements OnInit {

  public metainfo = metainfo;

  constructor(
    private router: Router,
    private authService: AuthService,
    private remoteService: RemoteService,
    private noticeService: NoticeService
  ) { }

  username: string;
  password: string;
  rememberMe: boolean;
  message: string;
  authModules: any[];
  loading = new BusyIndicator();

  ngOnInit() {
    this.loading.do(() => this.authService.getAuthModules()).subscribe((result) => {
      this.authModules = result;
    });
  }

  cancel() {
    this.router.navigate(['/app']);
  }

  authPassword() {
    const urlTarget = this.remoteService.toTargetUrl('authentication/password/logon');
    const request = {
      username: this.username,
      password: this.password
    };
    return this.remoteService
      .fetch(urlTarget, request, { message: 'Logon...' })
      .pipe(
        catchError(() => {
          this.noticeService.warning('Cannot contact server');
          return from(null);
        })
      )
      .subscribe(() => {
        const resumeTarget = this.remoteService.toTargetUrl('authentication/callback');
        window.location.href = resumeTarget;
      });
  }

  forward(module: string) {
    const targetUrl = this.remoteService.toTargetUrl('authentication/forward');
    let url;
    try {
      url = new URL(targetUrl);
    } catch(error) {
      url = new URL(this.remoteService.toExternalUrl(targetUrl));
    }
    url.searchParams.set('auth_module', module);
    window.location.href = url.toString();
  }

}
