import { CdkScrollable } from '@angular/cdk/scrolling';
import { Component } from '@angular/core';
import { FormsModule } from '@angular/forms';
import { MatButton } from '@angular/material/button';
import { MatDialogActions, MatDialogClose, MatDialogContent, MatDialogRef, MatDialogTitle } from '@angular/material/dialog';
import { MatFormField, MatLabel } from '@angular/material/form-field';
import { MatInput } from '@angular/material/input';

@Component({
    selector: 'app-pin-entry',
    imports: [MatDialogTitle, CdkScrollable, MatDialogContent, MatFormField, MatLabel, MatInput, FormsModule, MatDialogActions, MatButton, MatDialogClose],
    templateUrl: './pin-entry.component.html',
    styleUrls: ['./pin-entry.component.css']
})
export class PinEntryComponent {

  constructor(
    private dialogRef: MatDialogRef<PinEntryComponent>
  ) { }

  public pin = '';

  cancel() {
    this.dialogRef.close();
  }

  ok() {
    this.dialogRef.close(this.pin);
  }
}
