import { CdkScrollable } from '@angular/cdk/scrolling';
import { Component } from '@angular/core';
import { FormsModule } from '@angular/forms';
import { MatButton } from '@angular/material/button';
import { MatDialogActions, MatDialogClose, MatDialogContent, MatDialogRef, MatDialogTitle } from '@angular/material/dialog';
import { MatFormField, MatLabel } from '@angular/material/form-field';
import { MatInput } from '@angular/material/input';

@Component({
    templateUrl: './prompt.component.html',
    imports: [MatDialogTitle, CdkScrollable, MatDialogContent, MatFormField, MatLabel, MatInput, FormsModule, MatDialogActions, MatButton, MatDialogClose],
    styleUrls: ['./prompt.component.css']
})
export class PromptComponent {

  input: string;
  label: string;

  constructor(
    public dialogRef: MatDialogRef<any>
  ) {
    this.label = "Enter text";
  }

  onCancel() {
    this.dialogRef.close();
  }
}
