
import { Directive, ElementRef, HostBinding, Input, OnInit } from '@angular/core';

import { BusyIndicator } from './busy-indicator.service';

@Directive({
    selector: '[appBusy]',
    standalone: true
})
export class BusyIndicatorDirective implements OnInit {

  constructor(private el: ElementRef) { }

  @HostBinding('class')
  elementClass = '';

  // tslint:disable-next-line:no-input-rename
  @Input('appBusy') busyIndicator: BusyIndicator;

  ngOnInit() {
    this.busyIndicator.active.subscribe((value) => {
      if (value) {
        this.elementClass = 'busy';
      } else {
        this.elementClass = '';
      }
    });
  }
}
