import { AfterViewChecked, Directive, ElementRef, HostListener } from '@angular/core';

@Directive({
  selector: '[appTextareaResize]',
  standalone: true
})
export class TextareaResizeDirective implements AfterViewChecked {

  constructor(
    private elementRef: ElementRef
  ) { }

  ngAfterViewChecked(): void {
    if (document.activeElement === this.elementRef.nativeElement) {
      return;
    }
    /*
     * probably overkill to always compute, but couldn't quickly find a suitable
     * event to listen to.
     */
    let nativeTextarea = this.elementRef.nativeElement;
    // not handling wrapped lines; too expensive here
    let lines = nativeTextarea.value.split('\n').length;
    this.elementRef.nativeElement.rows = Math.max(Math.min(lines, 10), 2);
  }

  @HostListener('focus')
  private onFocus() {
    this.elementRef.nativeElement.rows = 10;
  }
}
