import { Observable } from 'rxjs';

export function readAsArrayBuffer(blob: Blob): Observable<ArrayBuffer> {
	return new Observable(observer => {
		const reader = new FileReader();

		reader.onerror = () => observer.error(reader.error);
		reader.onabort = () => observer.error(reader.error);
		reader.onload = () => observer.next(reader.result as ArrayBuffer);
		reader.onloadend = () => observer.complete();

		reader.readAsArrayBuffer(blob);
	});
}

export function readAsText(blob: Blob): Observable<string> {
	return new Observable(observer => {
		const reader = new FileReader();

		reader.onerror = () => observer.error(reader.error);
		reader.onabort = () => observer.error(reader.error);
		reader.onload = () => observer.next(reader.result as string);
		reader.onloadend = () => observer.complete();

		reader.readAsText(blob);
	});
}

